### **Overview**

- The **DNS protocol** is the first step in any internet connection, making the DNS layer an ideal place to stop threats early.
- **Cisco Umbrella DNS Security** acts as a DNS resolver and blocks malicious destinations by resolving them to a block page.
- Safe destinations are resolved to their correct IP addresses, while risky/unknown destinations are sent to the **Intelligent Proxy** for deeper inspection.

---

### **Key Features of Cisco Umbrella DNS Security**

#### **1. DNS Security Workflow**

- **Safe Destinations**: Umbrella resolves the DNS query to its appropriate IP address.
- **Malicious Destinations**: Umbrella blocks the connection or logs it based on policy settings.
- **Unknown/Risky Destinations**: Sent to the **Intelligent Proxy** for additional inspection before resolution.

#### **2. Intelligent Proxy**

- Routes only risky/unknown traffic for deeper URL inspection to prevent slow or broken internet access.
- Inspects:
    - Content of the destination.
    - Autonomous System Number (ASN) and domain relationships.
    - Cryptographically generated domain names.
- Configurable via DNS policy, with **SSL Decryption** recommended for HTTPS inspection.

---

### **Threat Intelligence**

- Powered by **Cisco Talos**, Umbrella understands global threats and relationships between internet identities.
- Detects anomalies in domain associations (e.g., unexpected redirects).
- Learns patterns of DNS requests (e.g., associated domains and newly seen domains).
- Validates **Top-Level Domain (TLD) geolocation** to flag mismatched IP locations.

---

### **Connection Methods to DNS Security**

#### **For On-Network Clients**

1. **Internal DNS or DHCP**:
    - Update DNS settings in the **DHCP scope** to protect all devices.
2. **Network Devices**:
    - Integrate DNS-layer security into Cisco routers, wireless LAN controllers, Meraki devices, and firewalls.
3. **Virtual Appliance**:
    - A DNS forwarder that provides internal IP visibility and granular control.
    - Integrates with **Active Directory** for user-level visibility and policy enforcement.

#### **For Off-Network Clients**

1. **Umbrella Roaming Security Module**:
    - Installed with **Cisco Secure Client** or **AnyConnect**, routes DNS queries to Umbrella with encryption.
2. **Standalone Umbrella Roaming Client**:
    - Lightweight agent for endpoints, providing DNS-layer security and policy enforcement.
3. **Chromebooks**:
    - Umbrella Chromebook client integrates DNS-layer security with Google G Suite.

#### **For Mobile Devices**

1. **iOS Devices**:
    - **Cisco Security Connector** provides DNS-layer protection via MDM-managed devices.
2. **Android Devices**:
    - **Cisco Secure Client with Umbrella Module** protects apps and browser traffic.
3. **Unmanaged Devices**:
    - Offers DNS-layer protection for personal devices not managed by MDM.

---

### **Advanced Configurations**

#### **Virtual Appliance for Local IP Granularity**

- Acts as a **conditional DNS forwarder**:
    - Resolves internal domains locally.
    - Forwards external domains to Umbrella's DNS resolvers.
- Records internal IP information for policy enforcement and reporting.
- Encrypts and authenticates DNS traffic using **EDNS** and **DNSCrypt** for enhanced security.

#### **Forcing DNS Use**

- Block alternate DNS servers (e.g., 8.8.8.8) at the firewall to ensure all devices use Umbrella’s DNS settings.

---

### **DNS Policy Management**

#### **Key Features**

- Policies define how Umbrella protects identities and manages DNS queries.
- **Default Policy**: Serves as a catchall with basic protection, applied when no other policy matches.
- **Policy Wizard**: A step-by-step tool to configure DNS policies for identities.

#### **Policy Configuration Process**

1. **Add Policy**:
    - Create a new policy or edit the Default Policy.
2. **Select Identities**:
    - Apply the policy to specific identities (e.g., users, groups, networks).
3. **Enable Components**:
    - Choose policy components to configure, such as security and content settings.
4. **Configure Security Settings**:
    - Block categories of threats like malware, phishing, or newly seen domains.
5. **Content Category Settings**:
    - Restrict access to specific categories (e.g., gambling, sports).
6. **Application Settings**:
    - Block applications like Netflix or Facebook.
7. **Destination Lists**:
    - Allow or block custom domains or URLs.
8. **File Analysis**:
    - Scan and inspect files on risky domains before download.
9. **Block Pages**:
    - Customize block pages shown to users when access is denied.
10. **Set Policy Details**:
    - Review the policy summary, name the policy, and save it.

---

### **Deployment Advantages**

- **Global Cloud Infrastructure**:
    - All clients use the same Umbrella IP addresses for DNS resolution.
- **Umbrella DNS IPs**:
    - IPv4: `208.67.222.222` and `208.67.220.220`
    - IPv6: `2620:119:35::35` and `2620:119:53::53`
- **Scalable Deployment**:
    - Update DNS settings at the DHCP server, firewall, or endpoint to deploy Umbrella across thousands of devices in minutes.
- **No Hardware Required**:
    - Delivered via the cloud, eliminating the need for on-premises appliances.